require( "scripts/style.lua" )

-- Start the Comic Screen Timer
StartComicScreenTimer();

TableInfoFont = {
  standardFont,
  30,
  BlackColor
};

LeftButtonGraphics = {
	"buttons/arrowleft_up.png",
	"buttons/arrowleft_down.png",
	"buttons/arrowleft_over.png"
};

RightButtonGraphics = {
	"buttons/arrowright_up.png",
	"buttons/arrowright_down.png",
	"buttons/arrowright_over.png"
};

MakeDialog
{
	Bitmap
	{ 
		image="images/ComicPanel2Sketch.jpg",	
		x=kCenter,
		y=kCenter,

		-- button to leave comic
		Button{
			x=680,
			y=550,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name = "next",
			type = kPush,
			label = "done",
			rolloversound = "assets/audio/sfx/dialog_roll.ogg",
			sound = "assets/audio/sfx/dialog_click.ogg",
			command=
				function()
					-- Pause the timer
					PauseComicScreenTimer();

					PopModal();
					--DoModal("scripts/album.lua");
				end
		};
		
		
		-- Here's to my first...
		Text
		{
			font = { comicFont, 17, BlackColor };
			x=65, y=34,
			w=163,h=36,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_2_1_a",
		};
		
		-- It was worth...
		Text
		{
			font = { comicFont, 15, BlackColor };
			x=169, y=71,
			w=105,h=50,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_2_1_b",
		};
		
		-- Uh oh...
		Text
		{
			font = { comicFont, 16, BlackColor };
			x=320, y=64,
			w=105,h=50,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_2_1_c",
		};
		
		-- RING!
		Text
		{
			font = { comicFont, 16, BlackColor };
			x=376, y=271,
			w=44,h=22,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_2_1_h",
		};
		
		-- Okay, calm down...
		Text
		{
			font = { comicFont, 17, BlackColor };
			x=534, y=46,
			w=195,h=60,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_2_1_d",
		};
		
		-- Don't worry...
		Text
		{
			font = { comicFont, 16, BlackColor };
			x=125, y=348,
			w=177,h=54,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_2_1_e",
		};
		
		-- Phew! That's all...
		Text
		{
			font = { comicFont, 16, BlackColor };
			x=352, y=313,
			w=126,h=64,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_2_1_f",
		};
		
		-- UNBELIEVABLE....
		Text
		{
			font = { comicFont, 18, BlackColor };
			x=498, y=326,
			w=180,h=57,
			flags = kVAlignCenter + kHAlignCenter,
			label= "comic_2_1_g",
		};
	}
}

PlayComicMusic();



